import { formatDistance } from "./lb/_lib/formatDistance.js";
import { formatLong } from "./lb/_lib/formatLong.js";
import { formatRelative } from "./lb/_lib/formatRelative.js";
import { localize } from "./lb/_lib/localize.js";
import { match } from "./lb/_lib/match.js";

/**
 * @category Locales
 * @summary Luxembourgish locale.
 * @language Luxembourgish
 * @iso-639-2 ltz
 * @author Daniel Waxweiler [@dwaxweiler](https://github.com/dwaxweiler)
 */
export const lb = {
  code: "lb",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
};

// Fallback for modularized imports:
export default lb;
