"use strict";
exports.faIR = void 0;
var _index = require("./fa-IR/_lib/formatDistance.cjs");
var _index2 = require("./fa-IR/_lib/formatLong.cjs");
var _index3 = require("./fa-IR/_lib/formatRelative.cjs");
var _index4 = require("./fa-IR/_lib/localize.cjs");
var _index5 = require("./fa-IR/_lib/match.cjs");

/**
 * @category Locales
 * @summary Persian/Farsi locale (Iran).
 * @language Persian
 * @iso-639-2 ira
 * @author Seyyed Morteza Moosavi [@smmoosavi]{@link https://github.com/smmoosavi}
 */
const faIR = (exports.faIR = {
  code: "fa-IR",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 6 /* Sat */,
    firstWeekContainsDate: 1,
  },
});
