"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMutationObserver = exports.setupModalAutoSizing = void 0;
var Modal_1 = require("../actions/Modal");
var MessageTransport_1 = require("../MessageTransport");
var platform_1 = require("./platform");
var AUTO_SIZE_CLASS = 'app-bridge-utils-modal-auto-size';
var autoSizeStylesheet = createAutoSizeStylesheet();
function createAutoSizeStylesheet() {
    if (typeof document === 'undefined') {
        return null;
    }
    var autoSizeStylesheet = document.createElement('style');
    autoSizeStylesheet.type = 'text/css';
    autoSizeStylesheet.innerHTML = "." + AUTO_SIZE_CLASS + " { overflow: hidden; height: auto; min-height: auto; }";
    return autoSizeStylesheet;
}
function addAutoSizing(app, id) {
    if (!autoSizeStylesheet) {
        return function () { };
    }
    var head = document.getElementsByTagName('head')[0];
    var classList = document.body.classList;
    head.appendChild(autoSizeStylesheet);
    classList.add(AUTO_SIZE_CLASS);
    var mutationObserver = createMutationObserver(app, id);
    return function () {
        classList.remove(AUTO_SIZE_CLASS);
        if (head.contains(autoSizeStylesheet)) {
            head.removeChild(autoSizeStylesheet);
        }
        if (mutationObserver) {
            mutationObserver.disconnect();
        }
    };
}
/**
 * Automatically track changes to the document.body height and dispatch and action to update the modal size
 * @remarks This utility should only be used for an app that is meant to open inside a Modal
 * @param app App Bridge client application instance
 * @returns function to remove the auto-size tracker for the document.body
 *
 * @public
 */
function setupModalAutoSizing(app) {
    return __awaiter(this, void 0, void 0, function () {
        function cleanup() {
            if (removeAutoSizing) {
                removeAutoSizing();
                removeAutoSizing = undefined;
            }
        }
        function handleModalSizeUpdate(appState) {
            var context = appState.context, id = appState.modal.id;
            if (platform_1.isMobile() || context !== MessageTransport_1.Context.Modal) {
                cleanup();
                return cleanup;
            }
            if (!removeAutoSizing) {
                removeAutoSizing = addAutoSizing(app, id);
            }
            return cleanup;
        }
        var removeAutoSizing;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, app.getState().then(handleModalSizeUpdate)];
                case 1:
                    _a.sent();
                    return [2 /*return*/, cleanup];
            }
        });
    });
}
exports.setupModalAutoSizing = setupModalAutoSizing;
/**
 * Sets up modal auto sizing, using a MutationObserver.
 *
 * @param app App Bridge client application instance
 * @param id Currently active modal instance ID
 *
 * @internal
 */
function createMutationObserver(app, id) {
    if (typeof document === 'undefined') {
        return;
    }
    var lastKnownWindowHeight = -1;
    var mutationTimeoutId;
    var mutationObserverConfig = {
        attributes: true,
        attributeOldValue: false,
        characterData: true,
        characterDataOldValue: false,
        childList: true,
        subtree: true,
    };
    var mutationObserver = new MutationObserver(debouncedResizeHandler);
    mutationObserver.observe(document, mutationObserverConfig);
    updateHeight();
    function debouncedResizeHandler() {
        if (mutationTimeoutId) {
            window.clearTimeout(mutationTimeoutId);
        }
        mutationTimeoutId = window.setTimeout(updateHeight, 16);
    }
    function updateHeight() {
        var height = document.body.scrollHeight;
        if (height !== lastKnownWindowHeight) {
            lastKnownWindowHeight = height;
            app.dispatch(Modal_1.updateModalSize({ id: id, height: String(height) }));
        }
    }
    return mutationObserver;
}
exports.createMutationObserver = createMutationObserver;
