import { Action, WebVitalsMetricPayload } from '@shopify/app-bridge-core/actions/WebVitals';
import { MetaAction, Group } from '../types';
import type { ClientApplication } from '../../client/types';
export { Action };
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.WebVitals;
}
export interface LargestContentfulPaintAction extends ActionBase {
    readonly type: typeof Action.LARGEST_CONTENTFUL_PAINT;
    payload: WebVitalsMetricPayload;
}
export interface FirstInputDelayAction extends ActionBase {
    readonly type: typeof Action.FIRST_INPUT_DELAY;
    payload: WebVitalsMetricPayload;
}
export interface CumulativeLayoutShiftAction extends ActionBase {
    readonly type: typeof Action.CUMULATIVE_LAYOUT_SHIFT;
    payload: WebVitalsMetricPayload;
}
export interface FirstContentfulPaintAction extends ActionBase {
    readonly type: typeof Action.FIRST_CONTENTFUL_PAINT;
    payload: WebVitalsMetricPayload;
}
export interface TimeToFirstByteAction extends ActionBase {
    readonly type: typeof Action.TIME_TO_FIRST_BYTE;
    payload: WebVitalsMetricPayload;
}
export interface InteractionToNextPaintAction extends ActionBase {
    readonly type: typeof Action.INTERACTION_TO_NEXT_PAINT;
    payload: WebVitalsMetricPayload;
}
export declare function largestContentfulPaint(payload: WebVitalsMetricPayload): LargestContentfulPaintAction;
export declare function firstInputDelay(payload: WebVitalsMetricPayload): FirstInputDelayAction;
export declare function cumulativeLayoutShift(payload: WebVitalsMetricPayload): CumulativeLayoutShiftAction;
export declare function firstContentfulPaint(payload: WebVitalsMetricPayload): FirstContentfulPaintAction;
export declare function timeToFirstByte(payload: WebVitalsMetricPayload): TimeToFirstByteAction;
export declare function interactionToNextPaint(payload: WebVitalsMetricPayload): InteractionToNextPaintAction;
export declare function initializeWebVitals(app: ClientApplication): void;
