'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var ReactDOM = require('react-dom');
var jsxRuntime = require('react/jsx-runtime');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var ReactDOM__default = /*#__PURE__*/_interopDefault(ReactDOM);

/**
 * This component is a wrapper around the App Bridge `ui-modal` element.
 * It is used to display an overlay that prevents interaction with the
 * rest of the app until dismissed.
 *
 * @see {@link https://shopify.dev/docs/api/app-bridge-library/react-components/modal}
 */
const Modal = /*#__PURE__*/react.forwardRef(function InternalModal({
  open,
  onShow,
  onHide,
  children,
  ...rest
}, forwardedRef) {
  const [modal, setModal] = react.useState();
  const {
    titleBar,
    saveBar,
    modalContent
  } = react.Children.toArray(children).reduce((acc, node) => {
    const nodeName = getNodeName(node);
    const isTitleBar = nodeName === 'ui-title-bar';
    const isSaveBar = nodeName === 'ui-save-bar';
    const belongToModalContent = !isTitleBar && !isSaveBar;
    if (belongToModalContent) {
      acc.modalContent.push(node);
    }
    return {
      ...acc,
      titleBar: isTitleBar ? node : acc.titleBar,
      saveBar: isSaveBar ? node : acc.saveBar
    };
  }, {
    modalContent: []
  });
  const contentPortal = modal && modal.content ? /*#__PURE__*/ReactDOM__default.default.createPortal(modalContent, modal.content) : null;
  react.useEffect(() => {
    if (!modal) return;
    if (open) {
      modal.show();
    } else {
      modal.hide();
    }
  }, [modal, open]);
  react.useEffect(() => {
    if (!modal || !onShow) return;
    modal.addEventListener('show', onShow);
    return () => {
      modal.removeEventListener('show', onShow);
    };
  }, [modal, onShow]);
  react.useEffect(() => {
    if (!modal || !onHide) return;
    modal.addEventListener('hide', onHide);
    return () => {
      modal.removeEventListener('hide', onHide);
    };
  }, [modal, onHide]);
  react.useEffect(() => {
    if (!modal) return;
    return () => {
      modal.hide();
    };
  }, [modal]);
  return /*#__PURE__*/jsxRuntime.jsxs("ui-modal", {
    ...rest,
    ref: modal => {
      setModal(modal);
      if (forwardedRef) {
        if (typeof forwardedRef === 'function') {
          forwardedRef(modal);
        } else {
          forwardedRef.current = modal;
        }
      }
    },
    children: [titleBar, saveBar, /*#__PURE__*/jsxRuntime.jsx("div", {
      children: contentPortal
    })]
  });
});
Modal.displayName = 'ui-modal';
function getNodeName(node) {
  if (!node) return;
  const rawNodeType = typeof node === 'object' && 'type' in node ? node.type : undefined;
  const nodeType = typeof rawNodeType === 'string' ? rawNodeType : undefined;
  const rawDisplayName = typeof rawNodeType === 'object' ? rawNodeType.displayName : undefined;
  const displayName = typeof rawDisplayName === 'string' ? rawDisplayName : undefined;
  return nodeType || displayName;
}

exports.Modal = Modal;
