export interface Indexable {
    [key: string]: any;
}
/**
 * Returns a deeply merged object with properties from the 2 provided objects
 * @remarks - Only deeply merge objects. The second argument overrides the
 * first if it is provided as `null`, `undefined` or an array.
 * @public
 * */
export default function mergeProps<T extends Indexable, T2 extends Indexable>(obj: T, newObj: T2): T | T2;
