@extends('layouts.app')

@section('title', 'storeReady')

@section('content')
      

<section class="header-main py-lg-5 py-2 pb-0" id="header-main">
        <div class="container">
            <header class="py-3 p-3 border-bottom shadow rounded-pill">
                <div class="container">
                    <div class="row align-items-center">
                        <!-- Logo -->
                        <div class="col-6">
                            <a href="/" class="text-decoration-none text-reset">
                                <img src="{{ asset('public/images/logo.svg') }}" alt="Logo" class="img-fluid" style="max-height: 32px;">
                            </a>
                        </div>
                        
                        
                        <div class="col-6 text-end">
                            <a href="{{ route('quiz') }}" class="btn btn-primary d-lg-inline-block me-2 d-none">Let’s Discuss <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"/></span></a>
                        </div>
                    </div>
                </div>
            </header>
        </div>
    </section>
    
    <!-- Main Content -->
    <main class="container">

        <section class="get-started">
            <div class="get-started__wrapper">
                <h2>Take this 45-second quiz to find the perfect Shopify store for you and launch in just 3 days.</h2>
                <a href="javascript:void(0)" class="btn btn-primary d-inline-block rounded-3" onclick="get_started()">Take this 45-second quiz <span class="button-icon icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></a>
                <p>Built for first-time founders | 100+ stores launched</p>
            </div>
        </section>

        <section class="gsf">
            <div class="gsf__wrapper">
                <form action="{{ route('quiz') }}" method="POST">
                    @csrf
                    <div class="row g-0">
                        <div class="col-md-6">
                            <div class="gsf__steps-wrapper">
                                <div class="gsf__back">
                                    <button type="button" onclick="gsf_step_back()">
                                        <svg width="22" height="21" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.43247 11.9661L11.9658 18.4994C12.2325 18.7661 12.3605 19.0772 12.3498 19.4327C12.3391 19.7883 12.2 20.0994 11.9325 20.3661C11.6658 20.6105 11.3547 20.7385 10.9991 20.7501C10.6436 20.7616 10.3325 20.6336 10.0658 20.3661L1.26581 11.5661C1.13247 11.4327 1.03781 11.2883 0.981806 11.1327C0.925806 10.9772 0.898695 10.8105 0.900473 10.6327C0.90225 10.455 0.93025 10.2883 0.984472 10.1327C1.03869 9.97719 1.13292 9.83275 1.26714 9.69941L10.0671 0.899412C10.3116 0.654967 10.6174 0.532745 10.9845 0.532745C11.3516 0.532745 11.668 0.654967 11.9338 0.899412C12.2005 1.16608 12.3338 1.48297 12.3338 1.85008C12.3338 2.21719 12.2005 2.53363 11.9338 2.79941L5.43247 9.29941H20.3325C20.7103 9.29941 21.0271 9.42741 21.2831 9.68341C21.5391 9.93941 21.6667 10.2559 21.6658 10.6327C21.6649 11.0096 21.5369 11.3265 21.2818 11.5834C21.0267 11.8403 20.7103 11.9679 20.3325 11.9661H5.43247Z" fill="#270030"/>
                                        </svg>
                                    </button>
                                </div>
                                <div class="gsf__progress">
                                    <div class="gsf__progress__text">
                                        <h4>Step <span><span class="current-step">1</span> of <span class="total-steps">5</span></span></h4>
                                    </div>
                                    <div class="gsf__progress__bar"></div>
                                </div>

                                <div class="gsf__steps">
                                    <div class="gsf__steps__items active" data-step="1">
                                        <h4>What best describes you?</h4>
                                        <div class="gsf__steps__items__field">
                                            <label for="self_describe_1">
                                                <input type="radio" name="self_describe" id="self_describe_1" value="Full-time employee looking for a side hustle">
                                                <span>Full-time employee looking for a side hustle</span>
                                            </label>
                                            <label for="self_describe_2">
                                                <input type="radio" name="self_describe" id="self_describe_2" value="Student with free time and ambition">
                                                <span>Student with free time and ambition</span>
                                            </label>
                                            <label for="self_describe_3">
                                                <input type="radio" name="self_describe" id="self_describe_3" value="Stay-at-home parent ready to earn from home">
                                                <span>Stay-at-home parent ready to earn from home</span>
                                            </label>
                                            <label for="self_describe_4">
                                                <input type="radio" name="self_describe" id="self_describe_4" value="Freelancer or gig worker always chasing growth">
                                                <span>Freelancer or gig worker always chasing growth</span>
                                            </label>
                                            <label for="self_describe_5">
                                                <input type="radio" name="self_describe" id="self_describe_5" value="Just want to launch my own business!">
                                                <span>Just want to launch my own business!</span>
                                            </label>
                                        </div>
                                        <div class="gsf__steps__items__message">Please select option to proceed next step</div>
                                        <button type="button" class="gsf__steps__next-step" onclick="gsf_next_step()">Proceed <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></button>
                                    </div>
                                    <div class="gsf__steps__items" data-step="2">
                                        <h4>What excites you most about starting a store?</h4>
                                        <div class="gsf__steps__items__field">
                                            <label for="what_excites_to_starting_store_1">
                                                <input type="radio" name="store_excitement" id="what_excites_to_starting_store_1" value="Extra income every month">
                                                <span>Extra income every month</span>
                                            </label>
                                            <label for="what_excites_to_starting_store_2">
                                                <input type="radio" name="store_excitement" id="what_excites_to_starting_store_2" value="Freedom to work on my own time">
                                                <span>Freedom to work on my own time</span>
                                            </label>
                                            <label for="what_excites_to_starting_store_3">
                                                <input type="radio" name="store_excitement" id="what_excites_to_starting_store_3" value="Launching something I’m proud of">
                                                <span>Launching something I’m proud of</span>
                                            </label>
                                            <label for="what_excites_to_starting_store_4">
                                                <input type="radio" name="store_excitement" id="what_excites_to_starting_store_4" value="Building a long-term asset">
                                                <span>Building a long-term asset</span>
                                            </label>
                                        </div>
                                        <div class="gsf__steps__items__message">Please select option to proceed next step</div>
                                        <button type="button" class="gsf__steps__next-step" onclick="gsf_next_step()">Proceed <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></button>
                                    </div>
                                    <div class="gsf__steps__items" data-step="3">
                                        <h4>How comfortable are you with tech and websites?</h4>
                                        <div class="gsf__steps__items__field">
                                            <label for="comfortable_with_tech_1">
                                                <input type="radio" name="tech_comfort" id="comfortable_with_tech_1" value="FNot at all - I need help!">
                                                <span>Not at all - I need help!</span>
                                            </label>
                                            <label for="comfortable_with_tech_2">
                                                <input type="radio" name="tech_comfort" id="comfortable_with_tech_2" value="I can manage if guided">
                                                <span>I can manage if guided</span>
                                            </label>
                                            <label for="comfortable_with_tech_3">
                                                <input type="radio" name="tech_comfort" id="comfortable_with_tech_3" value="I’m pretty tech-savvy">
                                                <span>I’m pretty tech-savvy</span>
                                            </label>
                                            <label for="comfortable_with_tech_4">
                                                <input type="radio" name="tech_comfort" id="comfortable_with_tech_4" value="I love tinkering with tools">
                                                <span>I love tinkering with tools</span>
                                            </label>
                                        </div>
                                        <div class="gsf__steps__items__message">Please select option to proceed next step</div>
                                        <button type="button" class="gsf__steps__next-step" onclick="gsf_next_step()">Proceed <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></button>
                                    </div>
                                    <div class="gsf__steps__items" data-step="4">
                                        <h4>What kind of store sounds most exciting?</h4>
                                        <div class="gsf__steps__items__field">
                                            <label for="kind_store_sounds_exciting_1">
                                                <input type="radio" name="store_type" id="kind_store_sounds_exciting_1" value="Trendy gadgets & tech">
                                                <span>Trendy gadgets & tech</span>
                                            </label>
                                            <label for="kind_store_sounds_exciting_2">
                                                <input type="radio" name="store_type" id="kind_store_sounds_exciting_2" value="Home & Lifetsyle">
                                                <span>Home & Lifetsyle</span>
                                            </label>
                                            <label for="kind_store_sounds_exciting_3">
                                                <input type="radio" name="store_type" id="kind_store_sounds_exciting_3" value="Fashion & Beauty">
                                                <span>Fashion & Beauty</span>
                                            </label>
                                            <label for="kind_store_sounds_exciting_4">
                                                <input type="radio" name="store_type" id="kind_store_sounds_exciting_4" value="Fitness & Wellness">
                                                <span>Fitness & Wellness</span>
                                            </label>
                                        </div>
                                        <div class="gsf__steps__items__message">Please select option to proceed next step</div>
                                        <button type="button" class="gsf__steps__next-step" onclick="gsf_next_step()">Proceed <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></button>
                                    </div>
                                    <div class="gsf__steps__items" data-step="5">
                                        <h4>Want help growing your store after it’s live?</h4>
                                        <div class="gsf__steps__items__field">
                                            <label for="help_growing_store_1">
                                                <input type="radio" name="help_after_launch" id="help_growing_store_1" value="Yes, I want expert support & guidance">
                                                <span>Yes, I want expert support & guidance</span>
                                            </label>
                                            <label for="help_growing_store_2">
                                                <input type="radio" name="help_after_launch" id="help_growing_store_2" value="Yes, I want ad creatives to start strong">
                                                <span>Yes, I want ad creatives to start strong</span>
                                            </label>
                                            <label for="help_growing_store_3">
                                                <input type="radio" name="help_after_launch" id="help_growing_store_3" value="Maybe later">
                                                <span>Maybe later</span>
                                            </label>
                                            <label for="help_growing_store_4">
                                                <input type="radio" name="help_after_launch" id="help_growing_store_4" value="I’m confident doing it myself">
                                                <span>I’m confident doing it myself</span>
                                            </label>
                                        </div>
                                        <div class="gsf__steps__items__message">Please select option to proceed next step</div>
                                        <button type="button" class="gsf__steps__next-step" onclick="gsf_next_step()">Proceed <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></button>
                                    </div>
                                </div>
                            </div>
                            <div class="gsf__claim-store">
                                <div class="gsf__claim-store__back">
                                    <button type="button" onclick="gsf_claim_back()">
                                        <svg width="22" height="21" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.43247 11.9661L11.9658 18.4994C12.2325 18.7661 12.3605 19.0772 12.3498 19.4327C12.3391 19.7883 12.2 20.0994 11.9325 20.3661C11.6658 20.6105 11.3547 20.7385 10.9991 20.7501C10.6436 20.7616 10.3325 20.6336 10.0658 20.3661L1.26581 11.5661C1.13247 11.4327 1.03781 11.2883 0.981806 11.1327C0.925806 10.9772 0.898695 10.8105 0.900473 10.6327C0.90225 10.455 0.93025 10.2883 0.984472 10.1327C1.03869 9.97719 1.13292 9.83275 1.26714 9.69941L10.0671 0.899412C10.3116 0.654967 10.6174 0.532745 10.9845 0.532745C11.3516 0.532745 11.668 0.654967 11.9338 0.899412C12.2005 1.16608 12.3338 1.48297 12.3338 1.85008C12.3338 2.21719 12.2005 2.53363 11.9338 2.79941L5.43247 9.29941H20.3325C20.7103 9.29941 21.0271 9.42741 21.2831 9.68341C21.5391 9.93941 21.6667 10.2559 21.6658 10.6327C21.6649 11.0096 21.5369 11.3265 21.2818 11.5834C21.0267 11.8403 20.7103 11.9679 20.3325 11.9661H5.43247Z" fill="#270030"/>
                                        </svg>
                                    </button>
                                </div>
                                <h3 class="mb-lg-4 mb-2"><strong>Awesome!</strong> You're ready to build a <span class="ksse"></span> store.  Your easiest path to freedom, income, and ownership.</h3>
                                <h4>Here’s what’s included in your launch package:</h4>
                                <ul class="my-2">
                                    <li>Custom Shopify store with 10 winning products</li>
                                    <li>Design, copy, branding, and setup</li>
                                    <li>Ready to launch in 72 hours</li>
                                </ul>
                                <h4>Launch Today for $249 (Normally $499)</h4>
                                <p>Only 7 discounted spots left this week</p>

                                <div class="gsf__claim-store__action d-flex flex-column gap-3 mt-lg-4 mt-2">
                                    <button type="submit" class="submit-btn">CLAIM YOUR STORE <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></button>                                    
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#claimModal" class="gsf__claim-store__popup-btn">Interactive Add-Ons <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></button>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 d-none d-md-block">
                            <div class="gsf__step-image">
                            </div>
                        </div>
                    </div>

                    <!-- Modal -->
                    <div class="modal fade claimModal" id="claimModal" tabindex="-1" aria-labelledby="claimModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-xl">
                            <div class="modal-content">
                                <div class="modal-body claimModal__wrapper">
                                    <button class="claimModal__close" type="button" data-bs-dismiss="modal">
                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M0.470316 0.704447C0.610942 0.563997 0.801566 0.485107 1.00032 0.485107C1.19907 0.485107 1.38969 0.563997 1.53032 0.704447L13.5303 12.7044C13.604 12.7731 13.6631 12.8559 13.7041 12.9479C13.7451 13.0399 13.7671 13.1392 13.7689 13.2399C13.7707 13.3406 13.7522 13.4407 13.7144 13.534C13.6767 13.6274 13.6206 13.7123 13.5494 13.7835C13.4781 13.8547 13.3933 13.9108 13.2999 13.9486C13.2065 13.9863 13.1065 14.0048 13.0058 14.003C12.9051 14.0013 12.8058 13.9792 12.7138 13.9382C12.6218 13.8972 12.539 13.8381 12.4703 13.7644L0.470316 1.76445C0.329866 1.62382 0.250977 1.4332 0.250977 1.23445C0.250977 1.0357 0.329866 0.845073 0.470316 0.704447Z" fill="#2A0133"/>
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M13.5298 0.704447C13.6703 0.845073 13.7492 1.0357 13.7492 1.23445C13.7492 1.4332 13.6703 1.62382 13.5298 1.76445L1.52985 13.7644C1.38767 13.8969 1.19963 13.9691 1.00532 13.9656C0.811023 13.9622 0.625638 13.8835 0.488225 13.7461C0.350812 13.6087 0.2721 13.4233 0.268672 13.229C0.265243 13.0347 0.337366 12.8466 0.469846 12.7044L12.4698 0.704447C12.6105 0.563997 12.8011 0.485107 12.9998 0.485107C13.1986 0.485107 13.3892 0.563997 13.5298 0.704447Z" fill="#2A0133"/>
                                        </svg>
                                    </button>
                                    <h2 class="claimModal__title">Interactive Add-Ons</h2>
                                    <div class="claimModal__items">
                                        <div class="row g-4">
                                            <div class="col-md-4">
                                                <div class="claimModal__item">
                                                    <h4>Launch Success Package (+$99)</h4>
                                                    <div class="claimModal__item__field">
                                                        <input type="checkbox" name="launch_success_package" id="add_ons_1" value="1">
                                                        <label for="add_ons_1">1:1 onboarding, live chat support, setup help, and expert guidance through your first month</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="claimModal__item">
                                                    <h4>Email Welcome Sequence (+$49)</h4>
                                                    <div class="claimModal__item__field">
                                                        <input type="checkbox" name="email_welcome_sequence" id="add_ons_2" value="1">
                                                        <label for="add_ons_2">Pre-written email flows to convert browsers into buyers</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="claimModal__item">
                                                    <h4>Legal & Policy Pack (+$29)</h4>
                                                    <div class="claimModal__item__field">
                                                        <input type="checkbox" name="legal_policy_pack" id="add_ons_3" value="1">
                                                        <label for="add_ons_3">Auto-generated policies for TOS, returns, privacy, etc.</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" class="claimModal__submit-btn">CLAIM YOUR STORE <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></button>                                
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </section>
        
        <section class="entrepreneurs-sec st-pt st-pb" id="entrepreneurs-sec">
            <div class="title-wrapper">
                <h2>Testimonials</h2>
            </div>
            <div class="owl-carousel entrepreneurs owl-theme">
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
@endsection

@push('styles')
    
@endpush

@push('scripts')
   
@endpush