<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('store_quiz_responses', function (Blueprint $table) {
            $table->id();            
            $table->string('description');
            $table->string('store_excitement');
            $table->string('tech_comfort');
            $table->string('store_type');
            $table->boolean('help_after_launch')->default(false);
            $table->boolean('launch_success_package')->default(false);
            $table->boolean('email_welcome_sequence')->default(false);
            $table->boolean('legal_policy_pack')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_quiz_responses');
    }
};
