<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ShopifyController;
use App\Models\Shop;
use Illuminate\Support\Facades\Log;

Route::get('/', function () {
    return view('home');
});

Route::get('quiz',[HomeController::class, 'index'])->name('quiz');
Route::post('quiz',[HomeController::class, 'saveQuiz'])->name('saveQuiz');

// Root route for app launch from Shopify
Route::get('/shopify-app', [ShopifyController::class, 'entryPoint'])->name('shopify.entry');


// 3. Shop data erasure
Route::post('/shopify-app/erase-shop-data', [ShopifyController::class, 'deleteShopData']);



// OAuth + Dashboard Routes
Route::prefix('shopify-app')->group(function () {
    Route::get('/install', [ShopifyController::class, 'install'])->name('shopify.install');
    Route::get('/callback', [ShopifyController::class, 'callback'])->name('shopify.callback');
    Route::get('/dashboard', [ShopifyController::class, 'dashboard'])->name('shopify.dashboard');
    
    Route::post('/request-data', [ShopifyController::class, 'requestCustomerData'])->name('shopify.request_data');
    
    Route::post('/erase-data', [ShopifyController::class, 'deleteCustomerData'])->name('shopify.erase_data');
    
});


Route::get('/clear-cache', function() {
	Auth::logout();
	Session::flush();
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    Artisan::call('optimize:clear');
    

     return "Cache cleared";
});

Route::get('/route-list', function () {
    $routes = Artisan::call('route:list');
    return "<pre>" . Artisan::output() . "</pre>";
});




Route::get('/maintenance/on', function () {
    Artisan::call('down', [
        '--secret' => 'admin-access-2025'
    ]);
    return 'App is now in maintenance mode with secret access.';
});

Route::get('/maintenance/off', function () {
    Artisan::call('up');
    return 'App is now live again!';
});