@extends('layouts.app')

@section('title', 'storeReady')

@section('content')
        <section class="header-main py-lg-5 py-2 pb-0" id="header-main">
        <div class="container">
            <header class="py-3 p-3 border-bottom shadow rounded-pill">
                <div class="container">
                    <div class="row align-items-center">
                        <!-- Logo -->
                        <div class="col-6">
                            <a href="/" class="text-decoration-none text-reset">
                                <img src="{{ asset('public/images/logo.svg') }}" alt="Logo" class="img-fluid" style="max-height: 32px;">
                            </a>
                        </div>
                        
                        
                        <div class="col-6 text-end">
                            <a href="{{ route('quiz') }}" class="btn btn-primary d-lg-inline-block me-2 d-none">Let’s Discuss <span class="button-icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"/></span></a>
                        </div>
                    </div>
                </div>
            </header>
        </div>
    </section>
    
    <!-- Main Content -->
    <main class="container">
        <section class="hero start-selling-sec st-pt st-pb">
            <div class="hero__wrapper">
                <h1>Start Selling in Just 3 Days—Your Business in a Box for <span>$499</span> $249</h1>
                <p>We’ll build your entire Shopify drop shipping store with winning products, AutoDS integration, and everything you need — no tech skills required.</p>
                <a href="{{ route('quiz') }}" class="btn btn-primary d-inline-block rounded-3">Claim My Store Now <span class="button-icon icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"/></span></a>
                <div class="hero__services-list">
                    <ul>
                        <li>Built-for-you Shopify store</li>
                        <li>10 winning drop shipping products</li>
                        <li>AutoDS connected & ready</li>
                        <li>Start selling in 72 hours</li>
                        <li>Zero coding or design required</li>
                    </ul>
                </div>
            </div>
            <div class="hero__trustpilot">
                <img src="{{ asset('public/images/trustpilot-image.svg') }}" alt="Trustpilot Image" class="img-fluid">
            </div>
        </section>

        <section class="wtw st-pt st-pb">
            <div class="wtw__content">
                <h2>Why This Works</h2>
                <p>We don’t just hand you a storefront — we deliver a profit-ready, product-loaded business with everything set up. You focus on growth, we handle the tech.</p>
            </div>
            <div class="wtw__services-list">
                <ul>
                    <li>Custom Shopify theme setup</li>
                    <li>Winning product research & import</li>
                    <li>Full AutoDS integration</li>
                    <li>Optimized Home/About/Contact/Legal pages</li>
                    <li>Mobile-responsive & SEO-ready store</li>
                    <li>Connected payment gateway</li>
                </ul>
            </div>
            <div class="wtw__action">
                <a href="{{ route('quiz') }}" class="btn btn-primary">Get My Business in a Box <span class="button-icon icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"/></span></a>
            </div>
        </section>
        
        <section class="how-it-works st-pt st-pb" id="how-it-works">
            <div class="title-wrapper pb-4">
                <h2>How It Works</h2>
            </div>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="step-card rounded-5 shadow-sm">
                        <div class="card-body p-4">
                            <img src="{{ asset('public/images/web-design.svg') }}" alt="Step 1" class="img-fluid mb-md-3 mb-2">
                            <h3>Tell Us About Your Store</h3>
                            <p>Fill out a short quiz (name, niche, goals).</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="step-card rounded-5 shadow-sm">
                        <div class="card-body p-4">
                            <img src="{{ asset('public/images/Build-Everything.svg') }}" alt="Step 2" class="img-fluid mb-3">
                            <h3>We Build Everything</h3>
                            <p>Your store is fully set up within 3 business days.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="step-card rounded-5 shadow-sm">
                        <div class="card-body p-4">
                            <img src="{{ asset('public/images/Start-Selling.svg') }}" alt="Step 3" class="img-fluid mb-3">
                            <h3>You Start Selling</h3>
                            <p>You get access to your ready-to-go business with everything connected</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="button-wrapper text-center pt-lg-5 pt-4">
                <a href="{{ route('quiz') }}" class="btn btn-primary d-inline-block rounded-3">View Demo Store <span class="button-icon icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"/></span></a>
            </div>
        </section>
        
        <section class="entrepreneurs-sec st-pt st-pb" id="entrepreneurs-sec">
            <div class="title-wrapper">
                <h2>What entrepreneurs say after working with us</h2>
            </div>
            <div class="owl-carousel entrepreneurs owl-theme">
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="enterpreneurs-card">
                        <div class="info-box">
                            <div class="image-wrapper">
                                <img src="{{ asset('public/images/enterpreneur-image.svg') }}" alt="Entrepreneur 1" class="img-fluid rounded-circle">
                            </div>
                            <div class="text-wrapper">
                                <h3>Zayn</h3>
                                <p>United Kingdom</p>
                                <img src="{{ asset('public/images/star-image.svg') }}" alt="Star Rating" class="star-rating">
                            </div>
                        </div>
                        <div class="info-full-para">
                            <p>“I got my store delivered in 48 hours. The setup was flawless. I made my first sale within a week.”</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="cta st-pt st-pb">
            <div class="cta__wrapper">
                <div class="cta__content">
                    <h3>Take this Quiz</h3>
                    <h4>Not sure what niche to pick? This quick quiz helps us customize your store.</h4>
                    <p>Regular price <span>$499</span> $249 – this week only! </p>
                    <h5 class="d-flex align-items-center gap-3 spot-text"><div class="circle pulse"></div><span> Only <span id="count">7</span> spots left this week.</span></h5>
                    <a href="{{ route('quiz') }}" class="btn btn-primary d-inline-block rounded-3">View Demo Store <span class="cross">$499</span> $249 <span class="button-icon icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></a>
                </div>
            </div>
        </section>

        <section class="faq st-pt st-pb">
            <div class="faq__title">
                <h2>FAQ</h2>
            </div>

            <div class="faq__wrapper">
                <div class="faq-item">
                    <h4>Q:Will I own the store?</h4>
                    <p><strong>A</strong>:Yes — it’s fully built on your Shopify account. You get 100% ownership.</p>
                </div>
                <div class="faq-item">
                    <h4>Q:What if I want to change products or my niche?</h4>
                    <p><strong>A</strong>:We include 1 free revision. Just tell us and we’ll update.</p>
                </div>
                <div class="faq-item">
                    <h4>Q:Do I need to know how to code?</h4>
                    <p><strong>A</strong>:No — this is 100% done-for-you. No design, dev, or setup work needed on your end.</p>
                </div>
                <div class="faq-item">
                    <h4>Q:What if I need help after delivery?</h4>
                    <p><strong>A</strong>:You can add our $99/month support plan for hands-on help anytime</p>
                </div>
                <div class="faq-item">
                    <h4>Q:Is there a rebuild policy?</h4>
                    <p><strong>A</strong>:Yes — we offer a free rebuild if you’re not happy.</p>
                </div>
            </div>
        </section>

        <section class="cta cta--content-wide  st-pt st-pb">
            <div class="cta__wrapper">
                <div class="cta__content">
                    <h3>Still figuring things out?</h3>
                    <h4>You don’t need to have everything mapped out. We’re happy to take a look, ask the right questions, and help you explore what’s possible.</h4>
                    <a href="{{ route('quiz') }}" class="btn btn-primary d-inline-block rounded-3">Reserve My Spot for <span class="cross">$499</span> $249 <span class="button-icon icon"><img src="{{ asset('public/images/button-arrow.svg') }}" alt="Button Arrow"></span></a>
                </div>
            </div>
        </section>
    </main>
@endsection

@push('styles')
    
@endpush

@push('scripts')
   
@endpush