<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StoreQuizResponse;

class HomeController extends Controller
{
    public function index()
    {
        return view('quiz');
    }
    public function saveQuiz(Request $request)
    {
          StoreQuizResponse::create([
            'self_describe' => $request->input('self_describe'),
            'store_excitement' => $request->input('store_excitement'),
            'tech_comfort' => $request->input('tech_comfort'),
            'store_type' => $request->input('store_type'),
            'help_after_launch' => $request->input('help_after_launch'),
            
            'launch_success_package' => $request->has('launch_success_package'),
            'email_welcome_sequence' => $request->has('email_welcome_sequence'),
            'legal_policy_pack' => $request->has('legal_policy_pack'),
        ]);

        return redirect()->back()->with('success', 'Quiz submitted successfully!');
    }
}
